*-------------------------------------------------------------------------------
*						Fig 2
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Fig 2", replace 
set more off     

**---------------------------------------
* Step1: Generate Data
**---------------------------------------
clear
clear all

use "whole_occ2000.dta",clear
append using "whole_occ2010.dta"
append using "whole_occ2015.dta"

*share_{o,t}
sort occ_name year
keep occ_number occ_name share year
reshape wide share,i(occ_number occ_name) j(year)
replace share2000=0 if share2000==.
replace share2010=0 if share2010==.
replace share2015=0 if share2015==.

*d_{o,t}=share_{o,t}-*share_{o,t-1}
gen d_share0010=(share2010-share2000)
gen d_share1015=(share2015-share2010)
gen d_share0015=(share2015-share2000)

*D_{t} and meanD_{o,t}
egen temp1=total(abs(d_share0015))
egen temp2=mean(abs(d_share0015))

*Re_d{o,t}
drop d_share0010 d_share1015 d_share0015

gen d_share0010=(share2010-share2000)/(share2010+share2000)*2

gen d_share1015=(share2015-share2010)/(share2015+share2010)*2

gen d_share0015=abs((share2015-share2000)/(share2015+share2000)*2)

*Adjust entrance and exit occupation 
replace d_share0010=2.1 if d_share0010==2
replace d_share0010=-2.1 if d_share0010==-2

replace d_share1015=2.1 if d_share1015==2
replace d_share1015=-2.1 if d_share1015==-2

*Re_D_{t} and meanRe_D_{o,t}, 00-15 has taken abs before 
egen cal_temp=sum(d_share0015)
egen cal_temp2=mean(d_share0015)


**---------------------------------------
* Step2: Plot
**---------------------------------------
twoway (histogram d_share0010,frac width(0.1) color(red) yaxis(1)) ///
 (histogram d_share1015,frac width(0.1)  color(black) yaxis(1)) ///
 ,scheme(plotplain) xlabel(,nogrid) xsize(6) ysize(3) ///
 legend (label(1 2000-2010) label(2 2010-2015) position(6) rows(1)) ylabel(,nogrid) ///
 xtitle("职业o的相对就业结构变动（Re_d）") yline(0,lp(solid)) ytitle("职业数占比（%）")
graph save "$Out_lab\Fig2",replace
graph export "$Out_lab\Fig2.png",replace

log close